<?php 
// ===== Project Detail (Single) — White tone + KPI + Timeline (Plan pill + Actual line) + Side donut + Jobs table

$BASE        = $BASE ?? '';
$allProjects = $seed['projects'] ?? [];
$allJobs     = $seed['jobs'] ?? [];

if (!function_exists('can_view_all')) { function can_view_all(){ return true; } }
if (!function_exists('user_team'))    { function user_team(){ return 'General'; } }
if (!function_exists('can_plan'))     { function can_plan(){ return true; } }

$pid = (int)($_GET['id'] ?? 0);

/* ---------- find this project with permission ---------- */
$project = null;
foreach ($allProjects as $p) {
  if ((int)($p['id'] ?? 0) !== $pid) continue;
  if (!can_view_all() && (($p['team'] ?? '') !== user_team())) continue;
  $project = $p; break;
}
if (!$project) {
  http_response_code(404);
  echo "<section class='solo white fs'><div class='wrap'><div class='empty'><div class='t1'>ไม่พบโครงการ</div><div class='t2'>ตรวจสอบลิงก์หรือสิทธิ์การเข้าถึงอีกครั้ง</div></div></div></section>";
  exit;
}

/* ---------- helpers ---------- */
function bucket_status($raw) {
  $s = strtolower(trim((string)$raw));
  if (in_array($s, ['done','complete','completed','finished','closed'])) return 'completed';
  if (in_array($s, ['active','in progress','ongoing','running','executing'])) return 'in_progress';
  if (in_array($s, ['planned','planning','scheduled'])) return 'planned';
  if (in_array($s, ['on hold','paused','hold','waiting'])) return 'on_hold';
  return 'other';
}
function dparse($s){ $t = strtotime((string)$s); return $t ?: null; }
function ymd($ts){ return $ts ? date('Y-m-d', $ts) : '—'; }
function job_no($j){ return $j['job_no'] ?? $j['code'] ?? $j['no'] ?? (isset($j['id']) ? ('JOB-'.(string)$j['id']) : '—'); }
function job_owner($j){ return $j['owner'] ?? $j['assignee'] ?? $j['department'] ?? $j['dept'] ?? $j['team'] ?? '—'; }
function job_title($j){ return $j['title'] ?? $j['name'] ?? 'Job'; }
function progress_guess($j){
  if (isset($j['progress'])) return max(0,min(100,(int)$j['progress']));
  $st = strtolower((string)($j['status']??''));
  return $st==='completed' || $st==='done' ? 100 : ($st==='in progress' || $st==='active' ? 60 : ($st==='planned' ? 10 : 0));
}
function toColSpan($s,$e,$axisStart,$axisEnd){
  if (!$s && !$e) return null;
  $cs = max($axisStart, $s ?: $e ?: $axisStart);
  $ce = min($axisEnd,   $e ?: $s ?: $axisEnd);
  if ($ce < $axisStart || $cs > $axisEnd) return null;
  $startDay = (int)date('j', $cs);
  $span     = max(1, (int)date('j', $ce) - $startDay + 1);
  return ['col'=>$startDay,'span'=>$span,'s'=>ymd($s), 'e'=>ymd($e)];
}

/* ---------- jobs of this project only ---------- */
$jobs = array_values(array_filter($allJobs, fn($j)=> (int)($j['project_id'] ?? 0) === $pid));

/* ---------- enrich ---------- */
$now = strtotime('today');
foreach ($jobs as &$j) {
  $j['_bucket'] = bucket_status($j['status'] ?? '');
  // PLAN (ยืดหยุ่น: plan_start/plan_end > start/end > due/date)
  $j['_p_start'] = dparse($j['plan_start'] ?? $j['start'] ?? $j['date'] ?? null);
  $j['_p_end']   = dparse($j['plan_end']   ?? $j['end']   ?? $j['due_date'] ?? $j['date'] ?? null);
  // ACTUAL (ถ้าไม่ระบุ จะเว้นว่าง)
  $j['_a_start'] = dparse($j['actual_start'] ?? null);
  $j['_a_end']   = dparse($j['actual_end']   ?? null);
  // primary date column
  $j['_date']  = $j['_p_start'] ?: $j['_p_end'] ?: $j['_a_start'] ?: $j['_a_end'];
  $j['_pct']   = progress_guess($j);
}
unset($j);
usort($jobs, fn($a,$b)=> ($a['_date']??PHP_INT_MAX) <=> ($b['_date']??PHP_INT_MAX));

/* ---------- KPI (เฉพาะโครงการนี้) ---------- */
$cnt = ['completed'=>0,'in_progress'=>0,'planned'=>0,'on_hold'=>0,'other'=>0];
$dueSoonDays = 14; $dueSoon = 0; $overdue = 0;
foreach ($jobs as $j){
  $cnt[$j['_bucket']] = ($cnt[$j['_bucket']] ?? 0) + 1;
  $due = dparse($j['due_date'] ?? null);
  $end = dparse($j['end'] ?? null);
  if ($due && $due >= $now && $due <= strtotime("+{$dueSoonDays} days", $now)) $dueSoon++;
  if ($due && (($j['_bucket']!=='completed' && $now > $due) || ($end && $end > $due))) $overdue++;
}
$running = $cnt['in_progress'] + $cnt['planned'];
$completed = $cnt['completed'];

/* ---------- month axis (use ?m=YYYY-MM ; default = current) ---------- */
$rawM = trim((string)($_GET['m'] ?? ''));
if ($rawM && preg_match('/^\d{4}-\d{2}$/', $rawM)) { $monthTs = strtotime($rawM.'-01'); }
else { $monthTs = strtotime(date('Y-m-01')); }
$daysInMon = (int)date('t', $monthTs);
$monthName = date('F Y', $monthTs);
$axisStart = $monthTs;
$axisEnd   = strtotime(date('Y-m-t 23:59:59', $monthTs));

/* ---------- timeline rows: new structure with PLAN pill + ACTUAL line ---------- */
$rows = [];
foreach ($jobs as $j) {
  $plan   = toColSpan($j['_p_start'], $j['_p_end'], $axisStart, $axisEnd);
  $actual = toColSpan($j['_a_start'], $j['_a_end'], $axisStart, $axisEnd);

  // beyond plan (เฉพาะเมื่อมีทั้ง plan & actual และ actual ยาวกว่าแผน)
  $beyond = null;
  if ($plan && $actual) {
    $planEndCol   = $plan['col'] + $plan['span'] - 1;
    $actualEndCol = $actual['col'] + $actual['span'] - 1;
    if ($actualEndCol > $planEndCol){
      $beyond = [
        'col'  => $planEndCol + 1,
        'span' => $actualEndCol - $planEndCol
      ];
    }
  }

  // ข้ามแถวที่ไม่มีทั้งแผนและจริงในเดือนนั้นเลย
  if (!$plan && !$actual) continue;

  $rows[] = [
    'title'  => job_title($j),
    'section'=> $j['section'] ?? ($j['group'] ?? ($j['phase'] ?? $j['assignee'] ?? '')),
    'status' => $j['_bucket'],
    'pct'    => $j['_pct'],
    'plan'   => $plan,
    'actual' => $actual,
    'beyond' => $beyond
  ];
}

/* ---------- side donut numbers ---------- */
$totalTasks = count($jobs);
$doneTasks  = $cnt['completed'];
?>
<section class="solo white fs">
  <!-- TOP KPI -->
  <div class="kpi-strip">
    <div class="kpi-tile">
      <div class="kpi-ico">📘</div>
      <div class="kpi-meta">
        <div class="kpi-title">Running</div>
        <div class="kpi-num"><?= (int)$running ?></div>
        <div class="kpi-sub">jobs in progress / planned</div>
      </div>
    </div>
    <div class="kpi-tile">
      <div class="kpi-ico">✅</div>
      <div class="kpi-meta">
        <div class="kpi-title">Completed</div>
        <div class="kpi-num"><?= (int)$completed ?></div>
        <div class="kpi-sub">in this project</div>
      </div>
    </div>
    <div class="kpi-tile">
      <div class="kpi-ico">⏳</div>
      <div class="kpi-meta">
        <div class="kpi-title">Due Soon</div>
        <div class="kpi-num"><?= (int)$dueSoon ?></div>
        <div class="kpi-sub">within <?= $dueSoonDays ?> days</div>
      </div>
    </div>
    <div class="kpi-actions">
      <a class="btn" href="<?= $BASE ?>/projects">← Back</a>
      <?php if (can_plan()): ?><a class="btn primary" href="<?= $BASE ?>/project/edit?id=<?= (int)$pid ?>">Edit</a><?php endif; ?>
    </div>
  </div>

  <div class="main-grid">
    <!-- LEFT: TIMELINE -->
    <div class="card timeline-card">
      <div class="card-head">
        <div>
          <div class="h1">Project timeline</div>
          <div class="h2">Plan vs Actual — <?= htmlspecialchars($project['name'] ?? '') ?></div>
        </div>
        <div class="mon-nav">
          <?php
            $prev = date('Y-m', strtotime('-1 month', $monthTs));
            $next = date('Y-m', strtotime('+1 month', $monthTs));
          ?>
          <a class="chip" href="?id=<?= (int)$pid ?>&m=<?= $prev ?>">◀</a>
          <span class="mon"><?= htmlspecialchars($monthName) ?></span>
          <a class="chip" href="?id=<?= (int)$pid ?>&m=<?= $next ?>">▶</a>
        </div>
      </div>

      <div class="timeline-wrap">
        <!-- Header Days -->
        <div class="tl-days" style="grid-template-columns: repeat(<?= $daysInMon ?>, 1fr);">
          <?php for ($d=1; $d<=$daysInMon; $d++):
            $ts = strtotime(date('Y-m-', $monthTs).str_pad($d,2,'0',STR_PAD_LEFT));
            $dw = strtoupper(substr(date('D', $ts),0,1)); ?>
            <div class="cell"><b><?= str_pad($d,2,'0',STR_PAD_LEFT) ?></b><span><?= $dw ?></span></div>
          <?php endfor; ?>
        </div>

        <!-- Rows -->
        <div class="tl-rows">
          <div class="row head">
            <div class="name">All Jobs</div>
            <div class="lane head-grid" style="grid-template-columns: repeat(<?= $daysInMon ?>, 1fr);"></div>
          </div>

          <?php 
          $colorSeq=0;
          foreach ($rows as $r): 
            $c = $colorSeq % 4; $colorSeq++;
          ?>
            <div class="row">
              <div class="name">
                <span class="dot <?= htmlspecialchars($r['status']) ?>"></span>
                <div class="twrap">
                  <div class="t1"><?= htmlspecialchars($r['title']) ?></div>
                  <?php if ($r['section']!==''): ?><div class="t2"><?= htmlspecialchars($r['section']) ?></div><?php endif; ?>
                </div>
              </div>
              <div class="lane" style="grid-template-columns: repeat(<?= $daysInMon ?>, 1fr);">
                
                <?php if ($r['actual']): ?>
                <!-- ACTUAL (เส้นบาง) -->
                <div class="bar actual slim"
                  style="grid-column: <?=  (int)$r['actual']['col'] ?> / span <?= (int)$r['actual']['span'] ?>;">
                    <span class="hint">Actual: <?= htmlspecialchars($r['actual']['s']) ?> → <?= htmlspecialchars($r['actual']['e']) ?></span>
                </div>
                <?php endif; ?>

                <?php if ($r['plan']): ?>
                <!-- PLAN (PILL โค้งมน) -->
                <div class="pill plan" data-c="<?= (int)$c ?>"
                  style="grid-column: <?= (int)$r['plan']['col'] ?> / span <?= (int)$r['plan']['span'] ?>;">
                  <div class="pill-track"></div>
                  <div class="pill-fill" style="--pct:<?= (int)$r['pct'] ?>"></div>
                  <div class="pill-knob"><span><?= (int)$r['pct'] ?>%</span></div>
                  <div class="pill-left">
                    <div class="pill-title"><?= htmlspecialchars($r['title']) ?></div>
                    <div class="pill-sub"><?= htmlspecialchars($r['plan']['s']) ?> – <?= htmlspecialchars($r['plan']['e']) ?></div>
                  </div>
                </div>
                <?php endif; ?>

                <?php if ($r['beyond']): ?>
                <!-- เกินแผน -->
                <div class="bar beyond slim"
                  style="grid-column: <?=  (int)$r['beyond']['col'] ?> / span <?= (int)$r['beyond']['span'] ?>;">
                  <span class="hint">Beyond plan</span>
                </div>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>

          <?php if (!$rows): ?>
            <div class="empty-lane">ยังไม่มีงานที่มีวันที่ในเดือนนี้</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- RIGHT: DEADLINES -->
    <aside class="side">
      <div class="card side-head">
        <div class="h1">Project deadlines</div>
        <div class="h2">Status of completion for all tasks</div>

        <div class="donut-box">
          <div class="donut" data-total="<?= (int)$totalTasks ?>" data-done="<?= (int)$doneTasks ?>"></div>
          <div class="d-num"><?= (int)$totalTasks ?></div>
        </div>
      </div>

      <div class="card side-stat">
        <div class="pill left ok"></div>
        <div class="stat-title">Complete before deadline: <b>
          <?php
            $before = 0;
            foreach ($jobs as $j){
              $due = dparse($j['due_date'] ?? null);
              $end = dparse($j['end'] ?? null);
              $st  = bucket_status($j['status'] ?? '');
              if ($due && $end && $st==='completed' && $end < $due) $before++;
            }
            echo (int)$before;
          ?>
        </b></div>
        <div class="stat-sub"><span class="delta">0%</span> than previous</div>
      </div>

      <div class="card side-stat">
        <div class="pill left info"></div>
        <div class="stat-title">Complete on deadline: <b>
          <?php
            $on = 0;
            foreach ($jobs as $j){
              $due = dparse($j['due_date'] ?? null);
              $end = dparse($j['end'] ?? null);
              $st  = bucket_status($j['status'] ?? '');
              if ($due && $end && $st==='completed' && date('Y-m-d',$end)===date('Y-m-d',$due)) $on++;
            }
            echo (int)$on;
          ?>
        </b></div>
        <div class="stat-sub"><span class="delta neg">-18%</span> than previous</div>
      </div>

      <div class="card side-stat">
        <div class="pill left warn"></div>
        <div class="stat-title">Complete after deadline: <b>
          <?php
            $after = 0;
            foreach ($jobs as $j){
              $due = dparse($j['due_date'] ?? null);
              $end = dparse($j['end'] ?? null);
              $st  = bucket_status($j['status'] ?? '');
              if ($due && (($st==='completed' && $end && $end > $due) || ($st!=='completed' && $now > $due))) $after++;
            }
            echo (int)$after;
          ?>
        </b></div>
        <div class="stat-sub"><span class="delta pos">+20%</span> than previous</div>
      </div>
    </aside>
  </div>

  <!-- JOBS TABLE (ด้านล่าง) -->
  <div class="wrap">
    <div class="card jobs-card">
      <div class="jobs-head">Jobs</div>
      <div class="table-wrap">
        <table class="jobs-table">
          <thead>
          <tr>
            <th style="width:140px">วันที่</th>
            <th style="width:140px">Job No</th>
            <th>หัวข้อ</th>
            <th style="width:180px">ผู้รับผิดชอบ</th>
            <th style="width:140px">สถานะ</th>
            <th style="width:110px"></th>
          </tr>
          </thead>
          <tbody>
          <?php if (!$jobs): ?>
            <tr><td colspan="6" class="empty-row">ยังไม่มีงานในโครงการนี้</td></tr>
          <?php else: foreach ($jobs as $j):
            $date = ymd($j['_date']);
            $no   = job_no($j);
            $ttl  = job_title($j);
            $own  = job_owner($j);
            $bkt  = $j['_bucket'];
            $jobId = (int)($j['id'] ?? 0);
          ?>
            <tr>
              <td><?= htmlspecialchars($date) ?></td>
              <td class="mono"><b><?= htmlspecialchars($no) ?></b></td>
              <td class="title-cell"><?= nl2br(htmlspecialchars($ttl)) ?></td>
              <td><?= htmlspecialchars($own) ?></td>
              <td><span class="badge <?= htmlspecialchars($bkt) ?>"><?= htmlspecialchars(ucwords(str_replace('_',' ', $bkt))) ?></span></td>
              <td class="action"><a class="link" href="<?= $BASE ?>/job?id=<?= $jobId ?>">รายละเอียด</a></td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</section>

<script>
/* ===== Donut (multi-ring look) ===== */
(function(){
  const el = document.querySelector('.donut');
  if (!el) return;
  const total = parseInt(el.getAttribute('data-total')||'0',10);
  const done  = parseInt(el.getAttribute('data-done')||'0',10);
  const pct   = total ? Math.max(0, Math.min(1, done/total)) : 0;

  const size=160, r1=60, r2=46, r3=32, sw=10;
  const C = r => 2*Math.PI*r;

  const svg = document.createElementNS('http://www.w3.org/2000/svg','svg');
  svg.setAttribute('viewBox', `0 0 ${size} ${size}`);
  svg.setAttribute('class','donut-svg');

  function ring(r, base, val, frac){
    const g = document.createElementNS('http://www.w3.org/2000/svg','g');
    const baseEl = document.createElementNS('http://www.w3.org/2000/svg','circle');
    baseEl.setAttribute('cx', size/2); baseEl.setAttribute('cy', size/2); baseEl.setAttribute('r', r);
    baseEl.setAttribute('fill','none'); baseEl.setAttribute('stroke', base); baseEl.setAttribute('stroke-width', sw);
    g.appendChild(baseEl);

    const v = document.createElementNS('http://www.w3.org/2000/svg','circle');
    v.setAttribute('cx', size/2); v.setAttribute('cy', size/2); v.setAttribute('r', r);
    v.setAttribute('fill','none'); v.setAttribute('stroke', val); v.setAttribute('stroke-width', sw);
    const Len = C(r)*Math.max(0, Math.min(1, frac));
    v.setAttribute('stroke-dasharray', `${Len} ${C(r)-Len}`);
    v.setAttribute('transform', `rotate(-90 ${size/2} ${size/2})`);
    g.appendChild(v);
    return g;
  }

  svg.appendChild(ring(r1, 'var(--line)', 'var(--ok)', pct));
  svg.appendChild(ring(r2, 'var(--line)', 'var(--info)', Math.min(1, pct*0.75)));
  svg.appendChild(ring(r3, 'var(--line)', 'var(--warn)', Math.min(1, pct*0.5)));
  el.appendChild(svg);
})();
</script>

<style>
/* =========================================================
   WHITE TONE — LEFT-LOCKED FULL WIDTH (Single Project Page)
   เพิ่ม: PLAN pill + ACTUAL line + BEYOND
   ========================================================= */

/* ---------- Design Tokens ---------- */
:root{
  --gutter: clamp(12px, 2.2vw, 28px);

  --bg:       #f6f8fb;
  --panel:    #ffffff;
  --panel-2:  #f2f6fb;
  --ink:      #0f172a;
  --muted:    #64748b;
  --line:     #e6eaf0;

  --primary:  #0ea5e9;
  --ok:       #16a34a;
  --info:     #2563eb;
  --warn:     #f59e0b;
  --hold:     #6b7280;
  --vio:      #8b5cf6;

  /* สี pill (ตามตัวอย่าง) */
  --pill0: #3b82f6;  --pill0-weak:#d9e8ff;
  --pill1: #8b5cf6;  --pill1-weak:#eadcff;
  --pill2: #f472b6;  --pill2-weak:#ffe1f1;
  --pill3: #f59e0b;  --pill3-weak:#fde7bf;
}

/* ---------- Reset & Base ---------- */
*,
*::before,
*::after{ box-sizing:border-box; }
html{ overflow-x:hidden; }
html,body{ height:100%; }
body{
  margin:0; background:var(--bg); color:var(--ink);
  font:14px/1.55 system-ui, -apple-system, Segoe UI, Roboto, "Noto Sans Thai", sans-serif;
}
a{ color:inherit; }

/* ---------- Global Containers ---------- */
.kpi-strip,
.main-grid,
.wrap{
  width:100%; max-width:100%;
  margin:0;
  padding-left:var(--gutter);
  padding-right:var(--gutter);
}

/* ---------- KPI Strip ---------- */
.kpi-strip{
  padding-top:14px; padding-bottom:14px;
  display:grid; grid-template-columns: 1.1fr 1.1fr 1.1fr 1fr; gap:12px;
  border-bottom:1px solid var(--line);
  background:var(--panel);
}
.kpi-tile{
  display:flex; align-items:center; gap:12px;
  background:var(--panel-2); border:1px solid var(--line);
  border-radius:12px; padding:14px;
}
.kpi-ico{
  width:40px; height:40px; border-radius:10px;
  background:#fff; display:grid; place-items:center; font-size:20px;
}
.kpi-meta .kpi-title{ font-weight:800; font-size:13px; color:#0b2038; }
.kpi-meta .kpi-num{ font-weight:900; font-size:20px; margin-top:2px; }
.kpi-meta .kpi-sub{ color:var(--muted); font-size:12px; margin-top:2px; }
.kpi-actions{ display:flex; align-items:center; justify-content:flex-end; }
.btn{
  padding:10px 12px; border-radius:10px; border:1px solid var(--line);
  background:#fff; color:var(--ink); cursor:pointer; text-decoration:none;
}
.btn.primary{ background:var(--primary); color:#fff; border-color:transparent; font-weight:900; }
@media (max-width:1100px){
  .kpi-strip{ grid-template-columns: 1fr 1fr; }
}

/* ---------- Main 2 Columns ---------- */
.main-grid{
  padding-top:14px; padding-bottom:14px;
  display:grid; grid-template-columns: 3fr 1fr; gap:14px;
}
@media (max-width:1100px){ .main-grid{ grid-template-columns: 1fr; } }

/* ---------- Cards / Head ---------- */
.card{ background:var(--panel); border:1px solid var(--line); border-radius:12px; overflow:hidden; }
.card-head{
  padding:16px; border-bottom:1px solid var(--line);
  display:flex; align-items:flex-end; justify-content:space-between;
}
.h1{ font-weight:900; font-size:20px; }
.h2{ font-size:12.5px; color:var(--muted); margin-top:4px; }
.chip{
  display:inline-flex; align-items:center; padding:4px 10px;
  border-radius:999px; background:#fff; border:1px solid var(--line); color:#0b2038;
}
.mon-nav{ display:flex; gap:8px; align-items:center; }
.mon-nav .mon{ font-weight:800; }

/* ---------- Timeline ---------- */
.timeline-wrap{ padding:6px 12px 16px 12px; }
.tl-days{
  display:grid; gap:0;
  background:var(--panel-2); border:1px solid var(--line);
  border-radius:8px; overflow:hidden;
}
.tl-days .cell{
  border-right:1px solid var(--line);
  padding:6px 0; text-align:center; font-size:11px; color:#475569;
}
.tl-days .cell:last-child{ border-right:0; }

.tl-rows{ margin-top:10px; }
.tl-rows .row{
  display:grid; grid-template-columns: 260px 1fr;
  border-top:1px solid var(--line);
}
.tl-rows .row.head{ border-top:0; }
.tl-rows .row .name{
  padding:12px; display:flex; align-items:center; gap:8px;
}
.twrap .t1{ font-weight:800; }
.twrap .t2{ font-size:12px; color:var(--muted); }
.tl-rows .row .lane{
  display:grid; gap:8px; padding:10px; overflow:auto; align-items:center; position:relative;
}
.tl-rows .row .head-grid{ height:34px; background:var(--panel-2); border-left:1px solid var(--line); }

/* status dot (ซ้ายชื่อ) */
.dot{ width:6px; height:22px; border-radius:4px; display:inline-block; background:var(--vio); }
.dot.completed{  background:var(--ok); }
.dot.in_progress{ background:var(--info); }
.dot.planned{    background:var(--warn); }
.dot.on_hold{    background:var(--hold); }
.dot.other{      background:var(--vio); }

/* ===== PLAN: pill style ===== */
.pill.plan{
  position:relative; height:48px; border-radius:999px;
  background:var(--pill-weak); box-shadow:0 4px 14px rgba(0,0,0,.06);
  display:flex; align-items:center; padding-left:18px; overflow:hidden; z-index:2;
}
.pill.plan[data-c="0"]{ --pill:var(--pill0); --pill-weak:var(--pill0-weak); }
.pill.plan[data-c="1"]{ --pill:var(--pill1); --pill-weak:var(--pill1-weak); }
.pill.plan[data-c="2"]{ --pill:var(--pill2); --pill-weak:var(--pill2-weak); }
.pill.plan[data-c="3"]{ --pill:var(--pill3); --pill-weak:var(--pill3-weak); }

.pill-track{ position:absolute; inset:0; background:var(--pill-weak); }
.pill-fill{
  position:absolute; left:0; top:0; bottom:0;
  width: calc(var(--pct,0) * 1%); background:var(--pill);
}
.pill-knob{
  position:absolute; top:50%;
  left: calc(var(--pct,0) * 1%); transform: translate(-50%,-50%);
  width:42px; height:42px; border-radius:999px; background:var(--pill);
  display:grid; place-items:center; color:#fff; font-weight:900;
  border:3px solid rgba(255,255,255,.7);
}
.pill-left{ position:relative; z-index:2; color:#0b2038; }
.pill-title{ font-weight:800; font-size:13px; }
.pill-sub{ font-size:11px; color:#334155; opacity:.9; }

/* ===== ACTUAL: slim line under pill ===== */
.bar.slim{
  height:8px; border-radius:999px; background:var(--line);
  align-self:center; position:relative; z-index:1;
}
.bar.actual.slim{ background:#d3e0ff; }
.bar.beyond.slim{ background:#ffd9a8; }

/* tooltip-ish text (optional) */
.bar .hint{
  position:absolute; top:-18px; left:0; font-size:11px; color:#64748b;
}

/* Empty */
.empty-lane{
  padding:20px; color:#64748b; font-size:13px; text-align:center;
  border:1px dashed var(--line); border-radius:10px; background:#fafafa;
}

/* ---------- Right Side (Donut + Stats) ---------- */
.side{ display:flex; flex-direction:column; gap:14px; }
.side-head{ padding:16px; }
.donut-box{
  margin:12px 0 4px; padding:16px; background:var(--panel-2);
  border:1px solid var(--line); border-radius:10px;
  display:grid; place-items:center; position:relative;
}
.donut-svg{ width:160px; height:160px; }
.d-num{ position:absolute; font-weight:900; font-size:26px; }

.side-stat{ padding:14px; display:flex; flex-direction:column; gap:6px; background:var(--panel); }
.pill.left{ width:20px; height:4px; border-radius:4px; margin-bottom:2px; }
.pill.left.ok{   background:var(--ok); }
.pill.left.info{ background:var(--info); }
.pill.left.warn{ background:var(--warn); }
.stat-title{ font-weight:800; }
.stat-sub{ color:var(--muted); font-size:12px; }
.delta{ padding:2px 6px; border-radius:999px; border:1px solid var(--line); }
.delta.neg{ border-color:#ef4444; color:#a40000; }
.delta.pos{ border-color:#10b981; color:#0a7f53; }

/* ---------- Jobs Table ---------- */
.wrap{ padding-top:6px; padding-bottom:14px; }
.jobs-head{ font-weight:900; padding:12px 12px 6px; }

.table-wrap{
  border:1px solid var(--line); border-radius:12px;
  background:#f7fafd; padding:6px;
}
.jobs-table{
  width:100%; border-collapse:separate; border-spacing:0;
  background:#fff; border-radius:10px; overflow:hidden;
}
.jobs-table thead th{
  background:#f3f6fb; color:#0b2038; font-weight:800;
  text-align:left; padding:12px 14px; border-bottom:1px solid var(--line);
}
.jobs-table tbody td{
  padding:14px; border-bottom:1px solid var(--line); vertical-align:top;
}
.jobs-table tbody tr:last-child td{ border-bottom:0; }
.jobs-table .mono{
  font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace;
}
.jobs-table .title-cell{ line-height:1.35; }
.jobs-table .action{ text-align:right; }
.link{ color:var(--primary); text-decoration:none; font-weight:700; }
.link:hover{ text-decoration:underline; }

/* Status badges (outline) */
.badge{
  display:inline-flex; align-items:center; gap:6px;
  padding:6px 10px; border-radius:999px; font-size:12px; font-weight:700;
  border:1px solid currentColor; background:#fff;
}
.badge.in_progress{ color:#2563eb; background:#eff6ff; }
.badge.planned{    color:#d97706; background:#fffbeb; }
.badge.completed{  color:#0f5132; background:#ecfdf5; }
.badge.on_hold{    color:#374151; background:#f3f4f6; }
.badge.other{      color:#5b21b6; background:#f5f3ff; }

/* Utilities */
.empty{ padding:30px 12px; text-align:center; color:#64748b; }
.empty .t1{ font-weight:900; }
.empty .t2{ font-size:12.5px; margin-top:4px; }
</style>
