<?php
// views/partials/nav.php
$u    = $user ?? ['name'=>'Guest','team'=>'-','role'=>'viewer'];
$BASE = $BASE ?? rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
if ($BASE === '/') $BASE = '';
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?: '/';

function is_active($href, $path){ return $href === $path ? ' is-active' : ''; }
?>
<header class="topbar" role="banner">
  <div class="topbar__left">
    <a class="brand" href="<?= $BASE ?>/">
      <span class="brand__logo" aria-hidden="true">FT</span>
      <span class="brand__name">Project Plan Tracker</span>
    </a>

    <nav class="menu" aria-label="Primary">
      <button class="menu__toggle" aria-expanded="false" aria-controls="primary-nav">☰</button>
      <div id="primary-nav" class="menu__items">
        <a class="menu__link<?= is_active($BASE.'/', $path) ?>" href="<?= $BASE ?>/">Dashboard</a>
        <a class="menu__link<?= is_active($BASE.'/projects', $path) ?>" href="<?= $BASE ?>/projects">Projects</a>
        <a class="menu__link<?= is_active($BASE.'/calendar', $path) ?>" href="<?= $BASE ?>/calendar">Calendar</a>
        <?php if (function_exists('can_admin') ? can_admin() : false): ?>
          <span class="menu__sep" aria-hidden="true"></span>
          <a class="menu__link<?= is_active($BASE.'/admin/users', $path) ?>" href="<?= $BASE ?>/admin/users">Admin · Users</a>
          <a class="menu__link<?= is_active($BASE.'/admin/teams', $path) ?>" href="<?= $BASE ?>/admin/teams">Admin · Teams</a>
        <?php endif; ?>
      </div>
    </nav>
  </div>

  <div class="topbar__right">
    <span class="chip chip--soft" title="สิทธิ์">
      🛡️ <?= htmlspecialchars($u['role']) ?>
    </span>
    <span class="chip" title="ทีม">
      👥 <?= htmlspecialchars($u['team']) ?>
    </span>

    <div class="userdrop">
      <button class="userdrop__btn" aria-haspopup="menu" aria-expanded="false">
        <span class="avatar"><?= strtoupper(mb_substr($u['name'] ?? 'U',0,1)) ?></span>
        <span class="userdrop__name"><?= htmlspecialchars($u['name']) ?></span>
        <span class="caret">▾</span>
      </button>
      <div class="userdrop__menu" role="menu">
        <div class="userdrop__header">
          <div class="avatar avatar--lg"><?= strtoupper(mb_substr($u['name'] ?? 'U',0,1)) ?></div>
          <div>
            <div class="u-name"><?= htmlspecialchars($u['name']) ?></div>
            <div class="u-meta">Role: <?= htmlspecialchars($u['role']) ?> · <?= htmlspecialchars($u['team']) ?></div>
          </div>
        </div>
        <a role="menuitem" class="userdrop__item" href="<?= $BASE ?>/auth/profile">โปรไฟล์</a>
        <a role="menuitem" class="userdrop__item" href="<?= $BASE ?>/auth/preferences">การตั้งค่า</a>
        <div class="userdrop__sep" role="none"></div>
        <a role="menuitem" class="userdrop__item danger" href="<?= $BASE ?>/logout">ออกจากระบบ</a>
      </div>
    </div>
  </div>
</header>
