<?php
$TITLE = $title ?? 'Project Plan Tracker';
$SCRIPT_NAME = $_SERVER['SCRIPT_NAME'] ?? '';
$BASE = rtrim(str_replace('\\','/', dirname($SCRIPT_NAME)), '/');
if ($BASE === '.' || $BASE === '/') $BASE = '';
?><!doctype html>
<html lang="th">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($TITLE) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;600;700&family=Inter:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?= $BASE ?>/assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/partials/nav.php'; ?>
  <main class="container">
    <?php $full = __DIR__ . '/' . ltrim($viewFile, '/\\'); if (is_file($full)) include $full; else echo '<pre>View not found: '.htmlspecialchars($full).'</pre>'; ?>
  </main>
  <footer class="footer">© <?= date('Y') ?> Project Plan Tracker</footer>
  <script>window.__SEED__ = <?= json_encode($seed, JSON_UNESCAPED_UNICODE) ?>;</script>
  <script src="<?= $BASE ?>/assets/js/app.js"></script>
</body>
</html>
