// public/assets/js/app.js
(function () {
  // Mobile primary nav
  const toggle = document.querySelector('.menu__toggle');
  const items  = document.getElementById('primary-nav');
  if (toggle && items){
    toggle.addEventListener('click', () => {
      const open = items.classList.toggle('open');
      toggle.setAttribute('aria-expanded', open ? 'true' : 'false');
    });
  }

  // User dropdown
  const btn = document.querySelector('.userdrop__btn');
  const menu = document.querySelector('.userdrop__menu');
  function closeMenu(){ if(menu){ menu.classList.remove('open'); btn?.setAttribute('aria-expanded','false'); } }
  function openMenu(){ if(menu){ menu.classList.add('open'); btn?.setAttribute('aria-expanded','true'); } }

  btn?.addEventListener('click', (e)=> {
    e.stopPropagation();
    const open = menu.classList.contains('open');
    open ? closeMenu() : openMenu();
  });
  document.addEventListener('click', closeMenu);
  document.addEventListener('keydown', (e)=> { if(e.key==='Escape') closeMenu(); });
})();
